/*	
Dash Station
yutakano@tim.hi-ho.ne.jp
May , 2005 	
*/

// SAVING AND RETRIEVING PREFERENCES
// setup() はbodyがロードされたときに起動する。
// その時にこのwidgetに環境設定がされているときはチェックして設定する。
var g_stop = 0 ;
var g_nextupdatetime = 0;
var g_timelimit = 0;
function setup()
{
	var dbg1 = "DBG "; // debug用
	document.getElementById("debugstr").innerText = dbg1 + ":0"; // debug 
	
	var ds_timetable = "../TEST.txt" ;
	if(window.widget){
		ds_timetable = widget.preferenceForKey("ds_timetable"); // 時刻表
		g_timelimit = widget.preferenceForKey("ds_timelimit"); // 駅までの時間
	}
	
	// 念のためにマイナスになっていたらゼロにする
	if ( g_timelimit < 0 ){	g_timelimit = 0; } ;
	if ( isNaN(g_timelimit) == true){	g_timelimit = 0; } ;

	if(window.widget){
		// 起動するたびに忘れてくれ
		widget.setPreferenceForKey("0","ds_forcehol");  
	}
	var ds_forcehol = 0;  // 強制祝日
	
	document.getElementById("debugstr").innerText = dbg1 + ":1" ; // debug 
	
	// Back の設定画面へのセット
	// 駅までの時刻のオプション設定
	if(window.widget){
		var i = 0 ;
		var j = 0 ;
		var s = 0 ;
		var t = 0 ;
		var w = 0 ;
		var mymax = 0 ;
		document.getElementById("debugstr").innerText = dbg1 + ":2" ; // debug 
		
		// Option の設定 (駅までの時間をpreferenceForKeyからセット)
		mymax = document.getElementById("back_timepopup").length ;
		for( i = 0 ; i < mymax ; i++ ){
			w = document.getElementById("back_timepopup").options[i].value ;
			if ( w == g_timelimit ){
				document.getElementById("back_timepopup").options[i].selected = true ;
			}
		};
		document.getElementById("debugstr").innerText = dbg1 + ":3"; // debug 
		
		
		// file名の一覧のセット 
		var myarray = new Array ;
		var returnstr = getallfilenames() ;

		myarray = returnstr.split("|") ; // 
		mymax =  ( myarray.length - 1 ) / 2 ; // 最後の,があるから -1 
		for(i = 0 ; i < mymax ; i++ ){
			s = i * 2 ;	// 0 2 4
			t = s + 1 ;	// 1 3 5
			w = document.getElementById("back_filepopup").length ;
			document.getElementById("back_filepopup").options[w] = new Option(myarray[t],myarray[s]) ;
			if ( myarray[s] == ds_timetable ){
				document.getElementById("back_filepopup").options[w].selected = true ;
			};
		};
	}
	
	dbg1 += "Option : " ;
	dbg1 += ds_timetable ;
	dbg1 += " : " ;
	dbg1 += g_timelimit ;
	document.getElementById("debugstr").innerText = dbg1 + ":4" ; // debug 

	// アクティベート関連
	if(window.widget){
		widget.onshow = onshow;
		widget.onhide = onhide;
	}
	
	// 時刻表データのタイトルを表示する
	document.getElementById("TableTitle").innerText = gettitle(ds_timetable);
	
//	g_nextupdatetime = nexttrain();	

	update();
	
	dbg1 += " : setup() end" ;
	document.getElementById("debugstr").innerText = dbg1 ; // debug 
}

function update(){
	//	時刻表の更新 
	//	自動更新は20秒とか30秒とかそのくらい。
	//	毎秒更新するほど重要じゃないし、1分以上だと長いだろう。
	//	5,6,10,12,15,20,30
	var mydate = new Date;
	var myhours = mydate.getHours();
	var myminutes = mydate.getMinutes();
	var myseconds = mydate.getSeconds();
	
	var myinterval = 60 - myseconds ;
	// 00秒までの時間 これでおよそ一分に一度の処理になる
	myinterval = Number(myinterval) * 1000 ;
	ds_timer = setTimeout("update()", myinterval); 
	
	// ディアクティベートの処理
	// ディアクティベートの結果 g_stop = 1 となる
	if(g_stop > 0){
		clearTimeout(ds_timer); 
	};
	
	// さらに省エネのために次の更新時刻までは nexttrain()関数を使用しない
	// この関数はファイルを読む処理があってディスクアクセスもあるので
	// なるべく使わない方がいいはず。
	// g_nextupdatetimeという変数を用意し、nexttrain()で取得した最初の時分を
	// 保存する。厳密にはnexttrain()で取得した時*60+分-駅までの時間。
	// この時間も3時間(180m)シフト込みで
	// 現在の時分とそのg_nextupdatetimeを比較して同じ以下だった時は
	// nexttrain()関数が動く。そうでない時はスルー。
	// g_timelimit  駅までの時間
	var nowtime = ( Number(myhours) * 60 ) + Number(myminutes) + Number(g_timelimit) ;
	if (nowtime < 180 ){
		nowtime += ( 24 * 60 ) ;
	}
	
	if( g_nextupdatetime <= nowtime ){
	// 時刻表の書き換え
	// nexttrain()のリターンは一番最初のデータの(時*60+分)
		g_nextupdatetime = nexttrain();
		;
	};
//	g_nextupdatetime = nexttrain();

	// 動作確認用
	document.getElementById("frontdbgstr1").innerText = dgbtime() ;
	
	// debug 
	var dbghh = Math.floor( g_nextupdatetime / 60 );
	var dbgmm = g_nextupdatetime % 60 ;
	if( dbgmm < 10 ){ dbgmm = "0" + dbgmm ;};
	document.getElementById("frontdbgstr2").innerText = "Next:" + dbghh + ":" + dbgmm + " / " + g_timelimit ;
	// 
}

function gettitle(filename){
	//	時刻表データからタイトルをセットする
	//	時刻表データのファイルの一行目をタイトルとして表示する
	//	filename = ファイル名
	var wkstr = filename ;
	var wkerror = "" ;
	if(window.widget)
	{
		// パスにスペースが入っていると誤作動する
		// コマンドのパラメータをつなぐスペースは一個じゃないとエラー？
		var command = "/bin/bash ./gettabletitle.sh " + "./tables/" + filename ;
		wkstr = widget.system(command,null).outputString ;
		wkerrstr = widget.system(command,null).errorString ;
	};
	if(wkstr.length > 64 ){
		wkstr = wkstr.substr(0,64);
	};
	
	return wkstr

}

function forceholiday(){
	//	例えばお盆休みなど祝日データに無い日で休日ダイヤときに
	//	表示を強制的に切り替える処理
	//	曜日ごとに色が変わるタイトル横の部分をクリックすると
	//	色が変わって祝日になる。
	//	トグル処理
	var holiday = 0 ;
	var nowdate = new Date ;
	var nowday = nowdate.getDay();	// まずは本日の曜日を取得

	if(window.widget)
	{
		holiday = widget.preferenceForKey("ds_forcehol"); 
	}
	if( holiday > 0 ){	// 強制祝日フラグが立っていたとき
		if(window.widget){
			widget.setPreferenceForKey("0","ds_forcehol");  
		}
		document.getElementById("ColorRect").style.backgroundColor = daycolor(nowday); // 7 = Holiday
		document.getElementById("wdaystr").innerText = daystr(nowday) ;
	}else{;
		if(window.widget){
			widget.setPreferenceForKey("1","ds_forcehol");  
		}
		document.getElementById("ColorRect").style.backgroundColor = daycolor(7); // 7 = Holiday
		document.getElementById("wdaystr").innerText = daystr(7) ;
	};
	// 時刻表の書き換え
	g_nextupdatetime = nexttrain();
}

function onshow(){
	//	時刻表のアップデート 
	//	自動更新は上手く動かないのでテスト中(20秒に一回アップデート予定)
	//	setInterval() が(i)ボタンのアニメーションと当たるようなので
	//	setTimeout() , clearTimeout() を使ってみる。
	g_stop = 0 ; // go!
	g_nextupdatetime = 0 ;
	update();
//	dgbupdatetime(); 
}

function onhide()
{
	//	時刻表の自動更新を停止
	//	widgetが隠れたら処理停止 Zzzzz
	g_stop = 1 ; // stop!!
}

function dgbtime()
{
	// Debug の時に使う時刻
	var dbgstr = "*";
	var dbgdate = new Date;
	var dbghh = dbgdate.getHours();
	var dbgmm = dbgdate.getMinutes();
	var dbgss = dbgdate.getSeconds();
	if (dbghh < 10) dbghh = "0" + dbghh;
	if (dbgmm < 10) dbgmm = "0" + dbgmm;
	if (dbgss < 10) dbgss = "0" + dbgss;
	
	// dbgstr = dbghh + ":" + dbgmm + ":" + dbgss + "";
	dbgstr = dbghh + ":" + dbgmm ; // 時分のみ使用
	return dbgstr;
}


// back 裏面の処理用

function changetime(elem)
{
	//	駅までの時間
	//	Popupの変更
	g_timelimit = elem.options[elem.selectedIndex].value ;
	if(window.widget)
	{
		widget.setPreferenceForKey(g_timelimit,"ds_timelimit");
	}
	// 時刻表データを新しいもので更新
	g_nextupdatetime = nexttrain();
	// document.getElementById("debugstr").innerText = "changetime(elem) : " + g_timelimit ; // debug 
}

function changefile(elem)
{	
	// 時刻表データのファイル名
	var ds_timetable = elem.value ;
	if(window.widget)
	{
		widget.setPreferenceForKey(ds_timetable,"ds_timetable");
	}
	// 時刻表データのタイトルを表示する
	document.getElementById("TableTitle").innerText = gettitle(ds_timetable);
	// 時刻表データを新しいもので更新
	g_nextupdatetime = nexttrain();
	// document.getElementById("debugstr").innerText = "changefile(elem) : " + ds_timetable ; // debug 
} 

function getallfilenames(){
	// 時刻表データのファイル名とタイトルを取得 
	// 基本は head -1 * 
	// 「 | 」区切りのデータを返す。「 , 」はタイトルに含むかもしれないから
	var wkstr =  "dummy | dummy |" ;
	
	if(window.widget)
	{
		// パスにスペースが入っていると誤作動する
		// コマンドのパラメータをつなぐスペースは一個じゃないとエラー？
		var command = "/usr/bin/perl ./getfilenames.pl" ;
		wkstr = widget.system(command,null).outputString ;
	}
	// document.getElementById("debugstr").innerText = "getallfilenames2() : " + wkstr ; // debug 
	return wkstr;
}
